unit MFZoomPage;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  SclRView, StdCtrls, ExtCtrls;

type
  TFZoomPage = class(TForm)
    srv: TSRichViewEdit;
    Panel1: TPanel;
    PreviewMode: TCheckBox;
    LoadRVF: TButton;
    OpenRVF: TOpenDialog;
    procedure srvClickPage(Sender: TSRichViewEdit;
      Button: TMouseButton; Shift: TShiftState; X, Y, PageNo: Integer);
    procedure PreviewModeClick(Sender: TObject);
    procedure LoadRVFClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FZoomPage: TFZoomPage;

implementation

{$R *.DFM}

procedure TFZoomPage.PreviewModeClick(Sender: TObject);
begin
  srv.ViewProperty.ZoomPercentIN := srv.ViewProperty.ZoomPercent;
  if PreviewMode.Checked then
    srv.ViewProperty.ViewMode := srvvmPreviewMode
  else
    srv.ViewProperty.ViewMode := srvvmEditMode;
end;

procedure TFZoomPage.srvClickPage(Sender: TSRichViewEdit;
  Button: TMouseButton; Shift: TShiftState; X, Y, PageNo: Integer);
var
     zpB, zpE, delta : Single;
begin
  if srv.ViewProperty.ViewMode = srvvmEditMode then exit;

  if (srv.ViewProperty.ZoomPercent = srv.ViewProperty.ZoomPercentIN) then
    zpE := srv.ViewProperty.ZoomPercentOUT
  else
    zpE := srv.ViewProperty.ZoomPercentIN;
  zpB := srv.ViewProperty.ZoomPercent;

  delta := (zpE - zpB) / 20;

  while ((zpB < zpE) and (delta > 0)) or
        ((zpB > zpE) and (delta < 0)) do
    begin
      zpB := zpB + delta;
      srv.ViewProperty.ZoomPercent := zpB;
      Application.ProcessMessages;
      Sleep(10);
    end;
end;

procedure TFZoomPage.LoadRVFClick(Sender: TObject);
begin
  if OpenRVF.Execute then
    srv.LoadRVF(OpenRVF.FileName);
end;

end.
